/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.client.TextBlockClient;

public class PlayerDialogData {
    public final Map<Integer, Set<Integer>> dialogsRead = new TreeMap<Integer, Set<Integer>>();

    public void loadNBTData(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        this.dialogsRead.clear();
        NBTTagList dialogs = compound.func_150295_c("DialogData", 10);
        for (int i = 0; i < dialogs.func_74745_c(); ++i) {
            NBTTagCompound nbtDialog = dialogs.func_150305_b(i);
            TreeSet<Integer> set = new TreeSet<Integer>();
            for (int id : nbtDialog.func_74759_k("OptionRead")) {
                set.add(id);
            }
            this.dialogsRead.put(nbtDialog.func_74762_e("Dialog"), set);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList dialogs = new NBTTagList();
        for (int dialogId : this.dialogsRead.keySet()) {
            NBTTagCompound nbtDialog = new NBTTagCompound();
            nbtDialog.func_74768_a("Dialog", dialogId);
            int[] set = new int[this.dialogsRead.get(dialogId).size()];
            int i = 0;
            for (int id : this.dialogsRead.get(dialogId)) {
                set[i++] = id;
            }
            nbtDialog.func_74783_a("OptionRead", set);
            dialogs.func_74742_a((NBTBase)nbtDialog);
        }
        compound.func_74782_a("DialogData", (NBTBase)dialogs);
    }

    public boolean has(int dialogId) {
        return this.dialogsRead.containsKey(dialogId);
    }

    public void read(int dialogId) {
        if (this.has(dialogId)) {
            return;
        }
        this.dialogsRead.put(dialogId, new TreeSet());
    }

    public void option(int dialogId, int optionId) {
        if (!this.dialogsRead.containsKey(dialogId)) {
            this.dialogsRead.put(dialogId, new TreeSet());
        }
        this.dialogsRead.get(dialogId).add(optionId);
    }

    public void addLogs(List<TextBlockClient> lines, String texture) {
    }
}

